<?php

namespace Discovereel\Columns;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Column extends Model 
{

    protected $table = 'colums';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function columnType()
    {
        return $this->belongsTo('ColumnType');
    }

    public function sections()
    {
        return $this->belongsToMany('Section')->withTimestamps();
    }

    public function theme()
    {
        return $this->belongsTo('Theme');
    }

    public function lists()
    {
        return $this->belongsToMany('List');
    }

}